unit GrafGeomListU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, contnrs, math;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Alakzatok1: TMenuItem;
    AListaLetrehozasa: TMenuItem;
    AListaTorlese: TMenuItem;
    Kilepes: TMenuItem;
    ListaRendezesX: TMenuItem;
    ListaRendezesY: TMenuItem;
    ListaRendezesTerulet: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure AListaLetrehozasaClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure AListaTorleseClick(Sender: TObject);
    procedure ListaRendezesXClick(Sender: TObject);
    procedure ListaRendezesYClick(Sender: TObject);
    procedure ListaRendezesTeruletClick(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses Geometria;
// A ltrejv alakzatokra a kzs s refencijval hivatkozunk
var
 OLista : TObjectList;

// A form ltrehozsakor ltrehozzuk a listt s megtesszk a
// szksges alapbelltsokat
procedure TForm1.FormCreate(Sender: TObject);
begin
  OLista:=TObjectList.Create;
  // A listbl trlt objektum meg is sznik
  Olista.OwnsObjects:=true;
  // 1 pixel vastag v
  Canvas.pen.width:=1;
  Randomize;
end;

// A lista feltltse alakzatokkal
procedure TForm1.AListaLetrehozasaClick(Sender: TObject);
var
  alakzat   : TPozicio;
  akod      : 0..3;
  i,x,y,a,b : integer;
  szin      : TColor;
  s         : string;
  db        : integer;
begin
 // Ha nem adok meg rtket kilpnk
 s:='2000';
 if not InputQuery('Adatbekrs','Az alakzatok szma:',s) then exit;
 // A listban trolt alakzatok megszntets
 OLista.Clear;
 form1.repaint;
 try
   db:=strtoint(s)
 except
   db:=1;
 end;
 for i:=1 to db do
   begin
      alakzat:=nil;
      akod:=random(4);
      szin:= RGB(random(256),random(256),random(256));
      // A form kliens terleten bell marad az alakzat
      a:=20+random(150);
      b:=20+random(200);
      x:=1+a div 2+random(form1.clientwidth-a);
      y:=1+max(a,b) div 2+random(form1.clientheight-max(a,b));
      case akod of
        0 :  alakzat:=TPont.Create(x,y,szin);
        1 :  alakzat:=TKor.Create(x,y,szin,a div 2);
        2 :  alakzat:=TNegyzet.Create(x,y,szin,a);
        3 :  alakzat:=TTeglalap.Create(x,y,szin,a,b);
      end;
      OLista.Add(alakzat);
    end;
end;

// A form jrafesttekor megjelentjk az alakzatokat
procedure TForm1.FormPaint(Sender: TObject);
var
  i : integer;
begin
  with Olista do
    for i:=0 to Count-1 do
      if Assigned(Items[i]) then TPozicio(Items[i]).Frissit;
end;

// A lista elemeinek trlse
procedure TForm1.AListaTorleseClick(Sender: TObject);
begin
   Olista.Clear;
   form1.repaint;
end;

// Az alakzatok rendezse az x-koordintjuk alapjn
procedure TForm1.ListaRendezesXClick(Sender: TObject);
  // A rendezshez hasznlt fggvny
  function HasonlitX(Item1, Item2: Pointer): Integer;
  begin
    result:=round(TPozicio(Item1).GetX-TPozicio(Item2).GetX);
  end;
begin
  OLista.Sort(@HasonlitX);
  form1.repaint;
end;

// Az alakzatok rendezse az y-koordintjuk alapjn
procedure TForm1.ListaRendezesYClick(Sender: TObject);
  // A rendezshez hasznlt fggvny
  function HasonlitY(Item1, Item2: Pointer): Integer;
  begin
    result:=round(TPozicio(Item1).GetY-TPozicio(Item2).GetY);
  end;
begin
  // Az elemek rendezse a tpusuk alapjn
  OLista.Sort(@HasonlitY);
  form1.repaint;
end;


// Az alakzatok rendezse a terletk alapjn
procedure TForm1.ListaRendezesTeruletClick(Sender: TObject);
  // A rendezshez hasznlt fggvny
  function HasonlitTer(Item1, Item2: Pointer): Integer;
  begin
    result:=round(TPozicio(Item1).Terulet-TPozicio(Item2).Terulet);
  end;
begin
  // Az elemek rendezse a terletk alapjn
  OLista.Sort(@HasonlitTer);
  form1.repaint;
end;

// Kilpskor trljk a listaelemeket s
// a listaobjektumot
procedure TForm1.KilepesClick(Sender: TObject);
begin
 if Assigned(OLista) then
  begin
    OLista.Clear;
    OLista.Free;
  end;
  Form1.Close;
end;

end.
